--------------------------------------------------------------------------------------------
-- Render Button Menu Items Actions 
--------------------------------------------------------------------------------------------

--------------------------------------
-- Active Shade Mode
--------------------------------------
MacroScript RenderButtonMenu_Switch_To_ActiveShade_Mode
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SWITCHTO_ACTIVESHADE_MODE_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SWITCHTO_ACTIVESHADE_MODE_TOOLTIP~ 

(
	on execute do
	(
        --call this before changing the render settings for UI consistency		
        maxOps.rendUseIterative = false
        renderers.target = "local"
		renderers.renderDialogMode = #activeShade
		--~RENDERBUTTON_CAPTION_ACTIVESHADE~
	)

 	on ischecked return (renderers.renderDialogMode == #activeShade)
)--end macro

--------------------------------------
-- Production Rendering  Mode
--------------------------------------
MacroScript RenderButtonMenu_Switch_To_Production_Mode
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SWITCHTO_PRODUCTION_MODE_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SWITCHTO_PRODUCTION_MODE_TOOLTIP~ 

(
	on execute do
	(
		rendUseNet = false --enforce the net render flag to off when executed. 
		maxOps.rendUseIterative = false
		renderers.target = "local"
		renderers.renderDialogMode = #production
		--~RENDERBUTTON_CAPTION_PRODUCTION~
	)

	on ischecked return (renderers.renderDialogMode == #production AND maxOps.rendUseIterative == false AND rendUseNet == false AND renderers.target == "local") 
)--end macro


--------------------------------------
--  Iterative Rendering Mode
--------------------------------------
MacroScript RenderButtonMenu_Switch_To_Iterative_Mode
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SWITCHTO_ITERATIVE_MODE_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SWITCHTO_ITERATIVE_MODE_TOOLTIP~ 

(
	on execute do
	(
		rendUseNet = false --enforce the net render flag to off when executed. 
		maxOps.rendUseIterative = true
		renderers.target = "local"
		renderers.renderDialogMode = #production
	)
	
	on ischecked return  (renderers.renderDialogMode == #production AND maxOps.rendUseIterative == true AND rendUseNet == false )	
)--end macro


--------------------------------------
--  Network Rendering
--------------------------------------
MacroScript RenderButtonMenu_Submit_to_Network_Rendering
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SUBMIT_TO_NETWORK_RENDER_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SUBMIT_TO_NETWORK_RENDER_TOOLTIP~ 

(
	on execute do
	(
		--Modifications have to be done with render dialog closed
		renderSceneDialog.close()

		--switch to production renderer if we were not in that mode and store the old mode
		-- before switching
		oldTarget 			 = renderers.target
		oldmode 			 = renderers.renderDialogMode
		oldUseIterativeValue = maxOps.rendUseIterative

		if (oldTarget != "local")do
		(
			renderers.target = "local"
		)

		if (oldmode != #production) do
		(
			renderers.renderDialogMode = #production
		)

		if (oldUseIterativeValue != false)do
		(
			maxOps.rendUseIterative = false
		)
		
		--enable net render
		oldUseNetValue = rendUseNet
		rendUseNet     = true
		--Simulate press render button in render dialog
		max quick render

		--Reset everything back to previous state
		rendUseNet 				= oldUseNetValue
		maxOps.rendUseIterative = oldUseIterativeValue
		renderers.target 		= oldTarget
		if (oldmode != #production) do
		(
			renderers.renderDialogMode = oldmode
		)
		renderSceneDialog.open()
	)
)--end macro


--------------------------------------
-- Cloud Rendering  Mode
--------------------------------------
MacroScript RenderButtonMenu_Switch_To_Cloud_Mode
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SWITCHTO_CLOUD_MODE_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SWITCHTO_CLOUD_MODE_TOOLTIP~ 

(
	on execute do
	(
		rendUseNet = false --enforce the net render flag to off when executed. 
		maxOps.rendUseIterative = false
		renderers.renderDialogMode = #production
		--~RENDERBUTTON_CAPTION_PRODUCTION~
		renderers.target = "cloud"
	)

	on ischecked return (renderers.renderDialogMode == #production AND maxOps.rendUseIterative == false AND rendUseNet == false AND renderers.target == "cloud") 
)--end macro
